///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DIALOGS_TABSECURITY_CPP
#define _DIALOGS_TABSECURITY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <PrSht.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/CRC32.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSecurityDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hAuthString     = NULL;
    static HWND hAuthKey        = NULL;
    static HWND hLocalCryptKey  = NULL;
    static HWND hAdminPassword1 = NULL;
    static HWND hAdminPassword2 = NULL;

    if(uMsg == WM_INITDIALOG)
    {
        char sText[1024];
		int iLength = 0;

		hAuthString     = GetDlgItem(hWnd, IDC_AUTHSTRING);
        hAuthKey        = GetDlgItem(hWnd, IDC_AUTHKEY);

        hLocalCryptKey  = GetDlgItem(hWnd, IDC_LOCALCRYPTKEY);
        hAdminPassword1 = GetDlgItem(hWnd, IDC_ADMINPASSWORD1);
        hAdminPassword2 = GetDlgItem(hWnd, IDC_ADMINPASSWORD2);

        iLength = strlen(gsAuthString);
		sprintf_s(sText, sizeof(sText), "%d bits (CRC: %X)", iLength * 8, FullCRC(gsAuthString, iLength));
		Set_Text(hAuthString, sText);

		iLength = strlen(gsAuthKey);
		sprintf_s(sText, sizeof(sText), "%d bits (CRC: %X)", iLength * 8, FullCRC(gsAuthKey, iLength));
		Set_Text(hAuthKey, sText);

        Set_Text(hLocalCryptKey,  "Not implemented");
        Set_Text(hAdminPassword1, "Not implemented");
        Set_Text(hAdminPassword2, "Not implemented");

        return TRUE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
/*
			char lsAuthString[1024 + 1];
            int liAuthStringLen = Get_TextEx(hAuthString, lsAuthString, 1024);
            if(liAuthStringLen == 0 || liAuthStringLen > 1024)
            {
                MessageBox(hWnd, "You must enter a valid authentication string. Between 1 and 1024 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsAuthKey[1024 + 1];
            int liAuthKeyLen = Get_TextEx(hAuthKey, lsAuthKey, 1024);
            if(liAuthKeyLen == 0 || liAuthKeyLen > 1024)
            {
                MessageBox(hWnd, "You must enter a valid authentication key. Between 1 and 1024 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }
*/
            char lsLocalCryptKey[255 + 1];
            int liLocalCryptKeyLen = Get_TextEx(hLocalCryptKey, lsLocalCryptKey, 255);
            if(liLocalCryptKeyLen == 0 || liLocalCryptKeyLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid local crypt key. Between 1 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsAdminPassword1[64 + 1];
            int liAdminPassword1Len = Get_TextEx(hAdminPassword1, lsAdminPassword1, 64);
            if(liAdminPassword1Len == 0 || liAdminPassword1Len > 64)
            {
                MessageBox(hWnd, "You must enter a valid administrators password. Between 1 and 64 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsAdminPassword2[64 + 1];
            int liAdminPassword2Len = Get_TextEx(hAdminPassword2, lsAdminPassword2, 64);
            if(liAdminPassword2Len == 0 || liAdminPassword2Len > 64)
            {
                MessageBox(hWnd, "You must enter a valid administrators password. Between 1 and 64 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            if(strcmp(lsAdminPassword1, lsAdminPassword2) != 0)
            {
                MessageBox(hWnd, "The administrators passwords do not match.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            //strcpy_s(gsAuthKey, sizeof(lsAuthKey), lsAuthKey);
            //strcpy_s(gsAuthString, sizeof(lsAuthString), lsAuthString);
            //strcpy_s(gsLocalCryptKey, sizeof(lsLocalCryptKey), lsLocalCryptKey);
            //strcpy_s(gsAdminPassword, sizeof(lsAdminPassword1), lsAdminPassword1);

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
